---
title: Lecture 20：函数的微分
tags:
  - 数学
categories: 
date: 2023-12-22
---
---
## 1.1 微分的定义
### 1.1.1 什么是微分
**为什么需要微分**
+ 微分的本质：微分本质是一个**微小的线性变化量**，是用一个线性函数作为原函数变化的逼近（或者叫近似）。
+ 导数是研究在一点的变化率，是研究改变的快慢；
有时需要研究一点的**改变量**；
+ 例子
	+ 比如现在的例子： $\begin{aligned}&f (x)=x^2 \\&\Delta f (x)=f (x_0+\Delta x)-f (x_0)=2 x_0\Delta x+(\Delta x)^2\end{aligned}$
	+ 当 $\Delta\mathrm{x}$ 很小时，此时 $\Delta f(x)\approx2\mathrm{x}_0\Delta\mathrm{x}$
	+ 即变化率和平方的部分无关，可以被省略掉；
		+ 图示：
			+ ![[Pasted image 20231222204211.png]]
			+ 蓝色的部分为次要部分，可以省略掉；
			+ 只需要保留绿色的部分；
	+ 这对于误差的估计很有用；

**微分和导数的关系**
+ 导数：是指函数在某一点处变化的快慢,是一种变化率。
+ 微分：是指函数在某一点处（趋近于无穷小）的变化量，是一种变化的量。
+ 关于它们的符号
	+ 将 $f^{\prime}(x)\Delta x$ 定义为 dy，因此 **dy 不是一个符号，而是一个具体的值**；
	+ 而 $\Delta y$ 表示的是函数值的变化，显然 dy 的真正含义是对这种变化的逼近。
	+ 也就是说我们定义微分，就是想借助微分这个工具来研究函数的变化趋势。
+ 根据我们的定义，导数和微分的关系自然而然就出来了，由 $dy=f^{\prime}(x)\Delta x$ ,自然就得到 $\frac{dy}{dx}=f^{\prime}(x)$。
	+ 是不是觉得导数和微分的关系其实也没有那么神秘，这一切都只源于那些数学大家的定义而已。所谓定义，肯定是人为的了，没什么道理可讲

### 1.1.2 微分的定义
##### **定义**： #微分
> <font color="#ccc1d9">描述：</font> $\text{若 }f(x_0+\Delta x)-f(x_0)=A\Delta x+o(\Delta x)\text{ ，则称 }f(x)$ $在 x _0点可微；$
> 核心：微分是函数改变量的线性主部；

**解释**
+ 什么是微积分 
	+ 在微小的局部，用一个均匀变化来代替非均匀变化；
+ 什么是微分 
	+ 微分就是一个函数该变量的近似值（线性主部）

**扩展解释**
+  $A\Delta x 称为 f(x)在 x_0 点的微分$
	+ 第一部分为函数变化的主要部分
	+ 第二部分为高阶无穷小，为次要部分
+ 即为：$dy=A\Delta x$
	+ $dy\text{是 }\Delta y\text{的线性主部}$
+ 在微小的局部，用一个均匀变化来代替非均匀变化，这就是微积分的定义；
	+ 比如：用线性变化的函数，来代表整体为非均匀变化的函数；

**微分的几何含义**
+ 微分 $dy=f^{\prime}(x_{0})dx$ 在几何上表示曲线 $y=f(x)$ 的切线上的增量；

### 1.1.3 可微分与可导
##### **定理**： #可微与可导的关系
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>在 $x_0$ 处可微的充分必要条件是 $f(x)$ 在 $x_0$ 处可导；
> 且：$dy=f^{\prime}(x)\Delta x=f^{\prime}(x)$

**解释**
+ （在一元函数的前提下）验证是否可微分 = 验证是否可导；
+ 所以：验证了可导 -> 可微分；

## 1.2 连续、可导、可微之间的关系
**图示**
![[Pasted image 20240317192744.png]]

**连续和可导**
+ **可导 -> 连续**
+ 证明：**可导推连续**
	+ 如果可导，则有：$\lim_{\Delta x\rightarrow0}\frac{\Delta y}{\Delta x}=f^{\prime}(x_0)$
	+ 因为 $\Delta y=\frac{\Delta y}{\Delta x}\cdot\Delta x$
	+ 所以其中的 $\frac{\Delta y}{\Delta x}$ 为常数，而 $\Delta x$ 趋向于 0，所以 $\Delta y$ 也趋向于 0
	+ 因此满足连续的定义：$\lim_{\Delta x\to0}\Delta y=0$
+ 连续不能推可导；
	+ 比如：$y=|x|$
	+ 这一点连续，但是左右导数不一样（左切线斜率是-1，右切线斜率是 1）
+ 可导可以推出连续；
	+ 正确：$f(x)在x_0$ 可导 ->  $f(x)$ 在 $x_0$ 处连续；
	+ 错误：$f(x)在x_0$ 可导  -> $f^{\prime}(x)$ 在 $x_0$ 处连续；
	+ 错误：$f(x)在x_0$ 可导  -> $\lim_{x\to x_0}f^{\prime}(x)$ 存在；
+ 推论：二阶导数存在不等于二阶导极限存在；
![[Pasted image 20240317190353.png]]

**可导和可微**
+ 可导可以推出可微；
+ 可微可以推出可导；

**连续和可微**
+ 可微可以推连续；
+ 连续不能推可导；
	+ 也是：$y=|x|$

**判断可导性的方法**
+ 判断可导性
	+ 不连续
		+ 一定不可导；
	+ 连续
		+ 直接用定义；
		+ 看左右导数是否存在且相等；
### 1.2.2 洛必达法则使用条件
**使用洛必达法则最多可用到**
1. $f(x)\text{n阶可导，可以保证：}f^{(n-1)}(x)$ 极限存在；
2. $f(x)n\text{ 阶连续可导，则可以保证}f^{(n)}(x)$ 极限存在，可以使用洛必达；

## 1.3 补充：微分的历史
### 1.3.1 古典微分学
**古典微分学的特点**
![[Pasted image 20240115172004.png]]
1. dy 和 dx 表示的是自变量和因变量的具体的变化
2. 根据想象中的无穷小这个东西，定义了切线
3. 然后将切线的斜率定义为导数
![[Pasted image 20240115171900.png]]
dx 到底是什么，一会为0，一会又不为0？？为什么一个量会有两种不同形态，而且还能完全没道理的自由转换。

### 1.3.2 极限微分学
极限被发明了出来。相应的什么是无穷小，也有了确切的、具体的定义。无穷小终于不再是幽灵了，被光明正大的纳入数学体系中；
![[Pasted image 20240115172055.png]]
无穷小，就是极限为0的量；极限的发明本质上是**让数学家们手上有了一套可以解释无穷小的理论体系**；

**和古典微分学的区别**
+ 古典微分学 
	+ $\mathrm{dy}=\Delta y$
+ 极限微分学 
	+ $\mathrm{dy}\approx\Delta y$
	+ **极限微分学中，微分是变化的逼近，而不是变化本身**
极限微分学的计算：
![[Pasted image 20240115172447.png]]